<?php
	/**
	 * @file
	 * jollyany's theme implementation to display a single Portfolio node.
	 */
	global $base_url;
	global $theme_root;
	global $image_default;
	
	// Grabs the firsts image path and sets $imagePath.
	$imagePath = $image_default;
	if(isset($node->uc_product_image['und'])) {
		$imagePath = file_create_url($node->uc_product_image['und'][0]['uri']); 
	}
	$termid = arg(2);
?>


	<div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
		<div class="shop_item">
			<?php print render($title_prefix); ?>
			<div class="entry">
				<img src="<?php print $imagePath; ?>" alt="" class="img-responsive">
				<div class="magnifier">
					<div class="buttons">
						<?php print render($content['add_to_cart']); ?>
					</div><!-- end buttons -->
				</div><!-- end magnifier -->
			</div><!-- end entry -->
			<div class="shop_desc">
				<div class="shop_title pull-left">
					<a href="<?php echo $node_url; ?>"><span><?php print $title ?></span></a>
					<span class="cats"><?php print jollyany_format_comma_field('taxonomy_catalog', $node); ?></span>
				</div>
				
				<span class="price pull-right">
					<?php print uc_currency_format($node->sell_price); ?>
				</span>
			</div><!-- end shop_desc -->
			<?php print render($title_suffix); ?>
		</div><!-- end item -->
		<div class="clearfix"></div>
	</div>
	