(function ($) {
  Drupal.behaviors.newsletter = {
    attach: function (context, settings) {
      $("input[name='email']", context).click(function () {
          if ($(this).val() == Drupal.t('user@example.com')) {
            $(this).val('');
          }
      });
      $("input[name='email']", context).blur(function () {
        if ($(this).val() == '') {
          $(this).val(Drupal.t('user@example.com'));
        }
      });
    },

    subscribeForm: function(data) {
      $.each(Drupal.settings.exposed, function(e,i) {
        if (!$('#edit-field-newsletter-list-' + Drupal.settings.lang + '-' + i).attr('checked')) {
          $('.form-item-exposed-' + i).hide();
        }

        $('#edit-field-newsletter-list-' + Drupal.settings.lang + '-' + i).click(function () {
          $('.form-item-exposed-' + i).toggle();
        });
      });
    }
  };
})(jQuery);
