<?php

/**
 * @file
 * Displays compatible modules for boost, descriptions of functionality and
 * links if not installed.
 */

/**
 * Returns a table listing of the status of recommended modules.
 */
function boost_compatible_output() {
  $modules_enabled = array();
  $modules_disabled = array();

  // Query from the database in case modules are already installed but not enabled
  $result = db_query("SELECT name, status FROM {system} WHERE type = 'module' ORDER BY weight ASC, name ASC");
  foreach ($result as $record) {
    if ($record->status == 1) {
      $modules_enabled[] = $record->name;
    }
    else {
      $modules_disabled[] = $record->name;
    }
  }

  // list of compatible modules
  $recommended = array(
    'boost_crawler' => array(
      'title' => 'Boost Crawler',
      'link' => 'http://drupal.org/project/boost' ,
      'description' => t('Minimal crawler - expires and regenerates pages only when content is edited and on next cron run. If this module is disabled, the content will be regenerated by the next visitor (who may have a slow page load). Only recommended for sites with low traffic, since the page cache will probably have been regenerated by the time the crawler accesses it. This is a Boost sub-module.'),
    ),
    'fast_404' => array(
      'title' => 'Fast 404',
      'link' => 'http://drupal.org/project/fast_404' ,
      'description' => t('Produces a faster "page not found" (404) page, reducing server load. Boost does not cache 404 pages since it would increase the size of the cache for pages which should not be accessed anyway. However, the default 404 mechanism of Drupal can be expensive in terms of performance. If you have a large amount of 404, consider adding a redirection for them in your .htaccess file.'),
    ),
    'globalredirect' => array(
      'title' => 'Global Redirect',
      'link' => 'http://drupal.org/project/globalredirect',
      'description' => t('Redirects pages to their canonical URL. Avoids caching two pages for the same content.'),
    ),
    'httprl' => array(
      'title' => 'HTTP Parallel Request & Threading Library',
      'link' =>  'http://drupal.org/project/httprl',
      'description' => t('Required by Boost crawler, performs HTTP requests to regenerate expired pages.'),
    ),
    'expire' => array(
      'title' => 'Cache Expiration',
      'link' => 'http://drupal.org/project/expire',
      'description' => t('Expire specific pages of the cache immediately when content is added or modified. Also required by the Boost crawler, to crawl expired content after expiration.'),
    ),
  );

  ksort($recommended);

  // uses array_intersect as array_intersect_key only came in PHP > 5.1
  $installed = array_intersect($modules_enabled, array_keys($recommended));
  $disabled = array_intersect($modules_disabled, array_keys($recommended));
  $not_installed = array_diff( array_diff( array_keys($recommended), $installed), $disabled );

  // prepare the table
  $header = array(t('Module'), t('Status'), t('Description'));

  $rows = array();

  foreach ($recommended as $module => $data) {
    $status = in_array($module, $not_installed) ? t('Not Installed') : (in_array($module, $disabled) ? t('Disabled') : t('Enabled'));
    $trclass = in_array($module, $not_installed) ? 'info' : (in_array($module, $disabled) ? 'warning' : 'ok' ) ;
    $module_link = l($data['title'], $data['link']);

    $rows[] = array(
      'data' => array(
        $module_link,
        $status,
        $data['description'],
      ),
      'class' => array($trclass),
      'no_striping' => TRUE,
    );
  }

  $output = '<p class="boost-listmodules-intro">' . t("The following modules can be useful for most common use cases. For more information, please read and contribute to the <a href='!url'>Boost handbook</a>.", array('!url' => 'http://drupal.org/node/1434362')) . '</p>';

  $output .= theme('table', array('attributes' => array('class' => array('system-status-report')), 'header' => $header, 'rows' => $rows));

  return array(
   'my_page' => array(
      '#markup' => $output,
    ),
  );
}

